importPackage(java.lang);

var maxCount = 2;

var outfile = new java.io.PrintWriter(new java.io.FileWriter("c:\\demo\\esm_out.txt", true));

var evt = scriptEnv.getCurrentEvent();

var sourceId = evt.getRv24();

if (sourceId && sourceId.length() > 0) {

	var list = DynamicList.forName("TempCounter");

	if (!list) {
		outfile.println("List does not exist");
	} else {
		
		var count = 1; 
		
		while (count <= maxCount) {
			if (!list.contains(String(count))) {
				list.addTransient(String(count));
				outfile.println("Added " + count + " to list");
				break;
			}
			++count;
		}

		if (count > maxCount) {
			outfile.println("About to stop source " + sourceId);
			var src = ESM.sourceForId(sourceId);
			src.stop();
			
			while(--count > 0) {
				list.remove(String(count));
				outfile.println("Removed " + count + " from list");
			}
		}
	}

}

outfile.close();
